DECLARE @TrigDt DATE;
DECLARE @LstEvntDt DATE;
DECLARE @DiffSec INT;

/*
if you use these for filtering you must remove the comment mark infront of the line in the where condition of 
the query that corrosponds
*/

--triggeredtimestamp
SET @TrigDt = '2020-02-06';
--lasteventtimestamp
SET @LstEvntDt = '2020-02-06';

/*
Used for the dateDiff line you can remove the comment mark and use this to find the resutlts that lie between 
triggeredtimestamp and lasteventtimestamp in seconds
*/

SET @DiffSec = 3600;

/* How long each activity has run for, the type of activity and the file (interaction or dataflow) they belong to, 
also indicates if they are recurring or not, to be run vs. Interaction_xxx */

SELECT ActivityName = df.processname, 
       df.activitytype, 
       df.lasteventtimestamp, 
       ActivityDurationSeconds = DATEDIFF(ss, df.triggeredtimestamp, df.lasteventtimestamp), 
       ActivityDurationMinutes = DATEDIFF(ss, df.triggeredtimestamp, df.lasteventtimestamp) / 60, 
       ActivityDurationHours = DATEDIFF(ss, df.triggeredtimestamp, df.lasteventtimestamp) / 60 / 60, 
       IsTest = df.issandbox, 
       IsRecurring = df.isinteractive, 
       [FileName] = wf.interactionname, 
       [FileType] = wf.workflowtype, 
       df.workflowassociationinstanceid, 
       ActivityID = df.processassociationid
FROM.op_dataworkflows df
    INNER JOIN.op_interactionworkflows wf ON df.workflowassociationinstanceid = wf.workflowassociationinstanceid
WHERE df.[status] = 'Completed'
      AND DATEDIFF(month, df.triggeredtimestamp, GETDATE()) <= 1
--AND df.triggeredtimestamp >= @TrigDt
--AND df.lasteventtimestamp <= @LstEvntDt
--AND Datediff(ss, df.triggeredtimestamp, df.lasteventtimestamp) >= 3600
ORDER BY [ActivityDurationMinutes] DESC;